/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChappleModel<T extends Entity>
extends AgeableListModel<T> {
    private static final String BEAK = "beak";
    private static final String WATTLE = "wattle";
    private static final String STALK = "stalk";
    private final ModelPart head;
    private final ModelPart beak;
    private final ModelPart wattle;
    private final ModelPart body;
    private final ModelPart stalk;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public ChappleModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.beak = this.head.m_171324_(BEAK);
        this.wattle = this.head.m_171324_(WATTLE);
        this.stalk = this.body.m_171324_(STALK);
        this.leftWing = this.body.m_171324_("left_wing");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightLeg = this.body.m_171324_("right_leg");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        PartDefinition bill = head.m_171599_(BEAK, CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chin = head.m_171599_(WATTLE, CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -4.0f, 6.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition stalk = body.m_171599_(STALK, CubeListBuilder.m_171558_().m_171514_(0, -1).m_171481_(0.0f, -5.0f, -0.5f, 0.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition left_wing = body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171481_(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171419_((float)4.0f, (float)-3.0f, (float)0.0f));
        PartDefinition right_wing = body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171480_().m_171481_(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-3.0f, (float)0.0f));
        PartDefinition left_leg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(9, 24).m_171481_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)1.0f, (float)3.0f, (float)1.0f));
        PartDefinition right_leg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(9, 24).m_171480_().m_171481_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)3.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void m_6973_(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.rightWing.f_104205_ = animationProgress;
        this.leftWing.f_104205_ = -animationProgress;
    }
}

